<!DOCTYPE html>
<html lang="ml">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>Care Club</title>
  <link rel="icon" href="ch centre_page-0001.jpg" type="image/jpeg">
  <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;500;600&display=swap" rel="stylesheet">
  <style>
    body {
      font-family: 'Poppins', sans-serif;
      background: linear-gradient(rgba(0, 0, 0, 0.7), rgba(0, 0, 0, 0.7)),
                  url('2ba38b31-5431-47c8-aac2-ba4b5e2bb0e6.jpeg') no-repeat center center fixed;
      background-size: cover;
      margin: 0;
      padding: 20px;
      color: #f5d774;
    }
    .container {
      max-width: 850px;
      margin: auto;
      background: rgba(0, 0, 0, 0.6);
      backdrop-filter: blur(10px);
      padding: 30px;
      border-radius: 20px;
      box-shadow: 0 8px 24px rgba(255, 215, 0, 0.2);
      border: 1px solid rgba(255, 215, 0, 0.3);
    }
    h2 {
      text-align: center;
      color: #ffd700;
      margin-bottom: 20px;
      text-shadow: 1px 1px 3px rgba(255, 215, 0, 0.6);
    }
    p, li {
      color: #fffad1;
      font-weight: 400;
      line-height: 1.6;
    }
    ul {
      padding-left: 20px;
    }
    .button-wrapper {
      text-align: center;
      margin-top: 30px;
    }
    button {
      background: linear-gradient(to right, #f5d774, #f1c40f);
      color: #000;
      padding: 12px 30px;
      font-size: 16px;
      font-weight: bold;
      border: none;
      border-radius: 30px;
      cursor: pointer;
      transition: background 0.3s ease;
    }
    button:hover {
      background: linear-gradient(to right, #ffe066, #f5d774);
    }
    footer {
      margin-top: 50px;
      padding: 15px;
      background-color: #f3f3fb;
      text-align: center;
      border-top: 1px solid #ccc;
      border-radius: 0 0 12px 12px;
      font-size: 16px;
      font-weight: bold;
    }
    footer span {
      background: linear-gradient(90deg, #ff6a00, #ee0979, #00c3ff);
      -webkit-background-clip: text;
      -webkit-text-fill-color: transparent;
      display: inline-block;
      margin-right: 10px;
    }
    footer img {
      height: 40px;
      vertical-align: middle;
    }
    @media (max-width: 600px) {
      .container { padding: 20px; }
      button { width: 100%; }
    }
  </style>
</head>
<body>
  <div class="container">
    <h2>"ആരോഗ്യം" എന്ത്? എന്തിന്?</h2>
    <p>​'ആരോഗ്യം' എന്നത് ഒരു വ്യക്തിയുടെ ശാരീരികവും മാനസികവും സാമൂഹികവുമായ നല്ല അവസ്ഥയെ സൂചിപ്പിക്കുന്നു. രോഗങ്ങൾ, വൈകല്യങ്ങൾ, വേദനകൾ എന്നിവ ഇല്ലാത്ത അവസ്ഥ മാത്രമല്ല, സന്തോഷത്തോടെയും സമാധാനത്തോടെയും ജീവിക്കാനുള്ള കഴിവ് കൂടിയാണ് ആരോഗ്യം.</p>
    <p><strong>​എന്തുകൊണ്ടാണ് ആരോഗ്യം പ്രധാനമാകുന്നത്?</strong></p>
    <p>​ആരോഗ്യമുള്ള ശരീരവും മനസ്സും ഉണ്ടെങ്കിൽ മാത്രമേ നമുക്ക് നമ്മുടെ ജോലികൾ, പഠനം, വീട്ടുജോലികൾ എന്നിവയെല്ലാം എളുപ്പത്തിൽ ചെയ്യാനാകൂ.</p>
    <p>മാനസികവും ശാരീരികവുമായ ആരോഗ്യം ഒരുപോലെ പ്രധാനമാണ്. നല്ല ആരോഗ്യശീലങ്ങൾ പിന്തുടരുന്നത് ആയുസ്സ് വർദ്ധിപ്പിക്കാനും വാർദ്ധക്യത്തിൽ ഉണ്ടാകാവുന്ന രോഗങ്ങളെ തടയാനും സഹായിക്കുന്നു. ആരോഗ്യമുള്ള ഒരാൾക്ക് മാത്രമേ തൻ്റെ കുടുംബത്തെയും സമൂഹത്തെയും സഹായിക്കാൻ കഴിയൂ. ചുരുക്കത്തിൽ, ആരോഗ്യമാണ് ഒരു നല്ല ജീവിതത്തിൻ്റെ അടിസ്ഥാനം.</p>
    <p>ആരോഗ്യ സംരക്ഷണത്തിനു വേണ്ടി ദിവസം ഒരു മണിക്കൂർ എങ്കിലും മാറ്റി വെക്കണം.</p>
    <ul>
      <li>രാവിലെ ശുദ്ധമായ രണ്ട് ഗ്ലാസ്സ് വെള്ളം കുടിച്ചു ഒരു രണ്ട് കിലോമീറ്റർ എങ്കിലും നടക്കുക.</li>
      <li>ലഘു വ്യായാമങ്ങൾ ചെയ്യുക.</li>
      <li>ശേഷം സാധാരണയായി നമ്മുടെ നാട്ടിൽ ലഭ്യമായ ഭക്ഷണം കഴിക്കുക.</li>
      <li>പ്രഭാത ഭക്ഷണം നല്ല രീതിയിൽ സുഭിക്ഷമായി കഴിക്കണം.</li>
      <li>മറ്റ് സമയങ്ങളിൽ ഭക്ഷണത്തിന് സമയത്തിനും അളവിലും കൃത്യത പാലിക്കാൻ ശ്രമിക്കണം.</li>
      <li>ജോലിക്ക് അനുസരിച്ചുള്ള ഭക്ഷണമേ കഴിക്കാൻ പാടുള്ളൂ.</li>
      <li>ശുദ്ധമായ വെള്ളം ഇടക്കിടക്ക് കുടിക്കുക.</li>
      <li>മറ്റുള്ളവരുമായി സൗഹൃദം സ്ഥാപിച്ച്, പോസിറ്റീവ് ആയ വാർത്തകളും മനസ്സിന് സന്തോഷം ഉണ്ടാക്കുന്ന കാര്യങ്ങളിൽ ഇടപെടാൻ ശ്രമിക്കുക.</li>
    </ul>
    <p>ഇത് അനുവർത്തിച്ചാൽ മികച്ച ആരോഗ്യമുള്ള സമൂഹമായി നമ്മൾക്ക് വളരാൻ കഴിയും.</p>

    <div class="button-wrapper">
      <form action="register.php" method="post">
        <button type="submit">Proceed</button>
      </form>
    </div>
  </div>

  <footer>
    <span>Powered by</span>
    <a href="https://workmateinfotech.com" target="_blank">
      <img src="https://workmateinfotech.com/images/Workmate_Infotech_Private_Limited____Logo_1_-0_1__1_-removebg-preview%201%20(2).png" alt="Workmate Infotech Logo">
    </a>
  </footer>
</body>
</html>
