<?php
$id = isset($_GET['id']) ? (int) $_GET['id'] : 0;

$servername = 'localhost';
$username   = 'gdhhsxmy_chcenterthennala';
$password   = 'chcenterthennala';
$dbname     = 'gdhhsxmy_chcenterthennala';

$conn = new mysqli($servername, $username, $password, $dbname);

if ($conn->connect_error) {
    die('Connection failed: ' . $conn->connect_error);
}

$name           = $age = $gender = $phone = '';
$diseases       = $other_disease = '';
$activities     = $other_activity = '';
$exercise_types = $other_exercise = '';
$med_use        = $med_list = '';
$hospital_visit = $hospital_details = '';

if ($id > 0) {
    $stmt = $conn->prepare('SELECT * FROM health_form_submissions WHERE id = ?');
    $stmt->bind_param('i', $id);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result && $row = $result->fetch_assoc()) {
        $name             = $row['name'];
        $age              = $row['age'];
        $gender           = $row['gender'];
        $phone            = $row['phone'];
        $diseases         = $row['diseases'];
        $other_disease    = $row['other_disease'];
        $activities       = $row['activities'];
        $other_activity   = $row['other_activity'];
        $exercise_types   = $row['exercise_types'];
        $other_exercise   = $row['other_exercise'];
        $med_use          = $row['med_use'];
        $med_list         = $row['med_list'];
        $hospital_visit   = $row['hospital_visit'];
        $hospital_details = $row['hospital_details'];
    }
    $stmt->close();
}
$conn->close();

function isChecked($csv, $val)
{
    $arr = array_map('trim', explode(',', $csv));

    return in_array($val, $arr) ? 'checked' : '';
}

$diseaseOptions  = ['പ്രമേഹം', 'രക്തസമ്മർദ്ദം', 'ഹൃദയ രോഗം', 'അസ്തിമജ്ജാരോഗം', 'കാൻസർ', 'മറ്റുള്ളത്'];
$activityOptions = ['വാക്സിനേഷൻ', 'ബിപി/ഷുഗർ', 'ക്യാമ്പ്', 'രക്തദാനം', 'മറ്റ്'];
$exerciseOptions = ['നടക്കൽ', 'യോഗ', 'ജിം', 'മറ്റുള്ളത്'];

$diseaseOtherChecked  = (strpos($diseases, 'മറ്റുള്ളത്') != false || !empty(trim($other_disease))) ? 'checked' : '';
$activityOtherChecked = (strpos($activities, 'മറ്റ്') != false || !empty(trim($other_activity))) ? 'checked' : '';
$exerciseOtherChecked = (strpos($exercise_types, 'മറ്റുള്ളത്') != false || !empty(trim($other_exercise))) ? 'checked' : '';
?>
<!DOCTYPE html>
<html lang="ml">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1"> <!-- ✅ Mobile friendly -->
    <title>Care Club - ആരോഗ്യ വിവര ശേഖരണ ഫോം</title>
   
  <link rel="icon" href="ch centre_page-0001.jpg" type="image/jpeg"><link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet" />
    <style>
        body { overflow-x: hidden; }
        h4, h5 { word-wrap: break-word; }
        /* Make checkbox/radio groups stack nicely on mobile */
        @media (max-width: 576px) {
            .form-check-inline {
                display: block !important;
                margin-bottom: 0.5rem;
            }
        }
         footer {
      margin-top: 50px;
      padding: 15px;
      background-color: #f3f3fb;
      text-align: center;
      border-top: 1px solid #ccc;
      border-radius: 0 0 12px 12px;
      font-size: 16px;
      font-weight: bold;
    }
    footer span {
      background: linear-gradient(90deg, #ff6a00, #ee0979, #00c3ff);
      -webkit-background-clip: text;
      -webkit-text-fill-color: transparent;
      display: inline-block;
      margin-right: 10px;
    }
    footer img {
      height: 40px;
      vertical-align: middle;
    }
    </style>
</head>
<body class="bg-light">
<div class="container-fluid my-3 my-md-5 px-3 px-md-5">
    <div class="card shadow">
        <div class="card-header bg-primary text-white">
            <h4>🧍‍♂️ ആരോഗ്യ വിവര ശേഖരണ ഫോം</h4>
        </div>
        <div class="card-body">
            <form action="save.php" method="POST" id="healthForm">
                <input type="hidden" name="id" value="<?php echo htmlspecialchars($id); ?>">

                <!-- വ്യക്തിഗത വിവരങ്ങൾ -->
                <h5 class="text-primary">🧍‍♂️ വ്യക്തിഗത വിവരങ്ങൾ</h5>
                <div class="mb-3">
                    <label>പേര്</label>
                    <input type="text" class="form-control" name="name" required value="<?php echo htmlspecialchars($name); ?>" />
                </div>
                <div class="mb-3">
                    <label>വയസ്സ്</label>
                    <input type="number" class="form-control" name="age" min="1" max="999" required id="ageInput" value="<?php echo htmlspecialchars($age); ?>" />
                </div>
                <div class="mb-3">
                    <label>ലിംഗം</label><br />
                    <div class="form-check form-check-inline">
                        <input class="form-check-input" type="radio" name="gender" value="പുരുഷൻ" required <?php echo ($gender == 'പുരുഷൻ') ? 'checked' : ''; ?> />
                        <label class="form-check-label">പുരുഷൻ</label>
                    </div>
                    <div class="form-check form-check-inline">
                        <input class="form-check-input" type="radio" name="gender" value="സ്ത്രീ" <?php echo ($gender == 'സ്ത്രീ') ? 'checked' : ''; ?> />
                        <label class="form-check-label">സ്ത്രീ</label>
                    </div>
                    <div class="form-check form-check-inline">
                        <input class="form-check-input" type="radio" name="gender" value="മറ്റുള്ളവ" <?php echo ($gender == 'മറ്റുള്ളവ') ? 'checked' : ''; ?> />
                        <label class="form-check-label">മറ്റുള്ളവ</label>
                    </div>
                </div>
                <div class="mb-3">
                    <label>മൊബൈൽ നമ്പർ</label>
                    <input type="tel" class="form-control" name="phone" required pattern="^[6-9]\d{9}$" placeholder="ഉദാ: 9876543210" value="<?php echo htmlspecialchars($phone); ?>" />
                    <div class="form-text text-muted">10-അക്കം സാധുവായ ഇന്ത്യൻ മൊബൈൽ നമ്പർ നൽകുക.</div>
                </div>

                <!-- രോഗങ്ങൾ -->
                <h5 class="text-primary mt-4">🏥 ആരോഗ്യ സംബന്ധമായ വിവരങ്ങൾ</h5>
                <label>നിലവിലുള്ള പ്രധാന രോഗങ്ങൾ:</label>
                <?php foreach ($diseaseOptions as $disease): ?>
                    <div class="form-check <?php echo ($disease == 'മറ്റുള്ളത്') ? 'mb-2' : ''; ?>">
                        <input type="checkbox" class="form-check-input disease-checkbox" name="diseases[]" value="<?php echo $disease; ?>" id="disease_<?php echo $disease; ?>" 
                            <?php echo ($disease == 'മറ്റുള്ളത്') ? $diseaseOtherChecked : isChecked($diseases, $disease); ?> />
                        <label class="form-check-label" for="disease_<?php echo $disease; ?>"><?php echo $disease; ?></label>
                    </div>
                <?php endforeach; ?>
                <input type="text" class="form-control mb-3" name="other_disease" placeholder="മറ്റ് രോഗം" id="otherDiseaseInput" <?php echo (!empty($other_disease)) ? '' : 'disabled'; ?> value="<?php echo htmlspecialchars($other_disease); ?>" />

                <!-- മരുന്ന് ഉപയോഗം -->
                <div class="mb-3">
                    <label>മരുന്ന് ഉപയോഗം:</label><br />
                    <div class="form-check form-check-inline">
                        <input type="radio" class="form-check-input" name="med_use" value="ഉണ്ട്" id="medUseYes" required <?php echo ($med_use == 'ഉണ്ട്') ? 'checked' : ''; ?> />
                        <label class="form-check-label">ഉണ്ട്</label>
                    </div>
                    <div class="form-check form-check-inline">
                        <input type="radio" class="form-check-input" name="med_use" value="ഇല്ല" id="medUseNo" <?php echo ($med_use == 'ഇല്ല') ? 'checked' : ''; ?> />
                        <label class="form-check-label">ഇല്ല</label>
                    </div>
                </div>
                <div class="mb-3">
                    <label>മരുന്നുകളുടെ പേര്/തരം</label>
                    <input type="text" class="form-control" name="med_list" id="medList" <?php echo ($med_use == 'ഉണ്ട്') ? '' : 'disabled'; ?> value="<?php echo htmlspecialchars($med_list); ?>" />
                </div>

                <!-- Hospital visit -->
                <div class="mb-3">
                    <label>ആശുപത്രിയിൽ പോയിട്ടുണ്ടോ (6 മാസത്തിനുള്ളിൽ)?</label><br />
                    <div class="form-check form-check-inline">
                        <input type="radio" class="form-check-input" name="hospital_visit" value="ഉണ്ട്" id="hospitalVisitYes" required <?php echo ($hospital_visit == 'ഉണ്ട്') ? 'checked' : ''; ?> />
                        <label class="form-check-label">ഉണ്ട്</label>
                    </div>
                    <div class="form-check form-check-inline">
                        <input type="radio" class="form-check-input" name="hospital_visit" value="ഇല്ല" id="hospitalVisitNo" <?php echo ($hospital_visit == 'ഇല്ല') ? 'checked' : ''; ?> />
                        <label class="form-check-label">ഇല്ല</label>
                    </div>
                </div>
                <div class="mb-3">
                    <input type="text" class="form-control" name="hospital_details" id="hospitalDetails" placeholder="വിശദീകരണം" <?php echo ($hospital_visit == 'ഉണ്ട്') ? '' : 'disabled'; ?> value="<?php echo htmlspecialchars($hospital_details); ?>" />
                </div>

                <!-- പ്രതിരോധ പ്രവർത്തനങ്ങൾ -->
                <h5 class="text-primary mt-4">🛡️ രോഗ പ്രതിരോധ പ്രവർത്തനങ്ങൾ</h5>
                <?php foreach ($activityOptions as $activity): ?>
                    <div class="form-check <?php echo ($activity == 'മറ്റ്') ? 'mb-2' : ''; ?>">
                        <input type="checkbox" class="form-check-input activity-checkbox" name="activities[]" value="<?php echo $activity; ?>" id="activity_<?php echo $activity; ?>" 
                            <?php echo ($activity == 'മറ്റ്') ? $activityOtherChecked : isChecked($activities, $activity); ?> />
                        <label class="form-check-label" for="activity_<?php echo $activity; ?>"><?php echo $activity; ?></label>
                    </div>
                <?php endforeach; ?>
                <input type="text" class="form-control mb-3" name="other_activity" placeholder="മറ്റ് പ്രവർത്തനം" id="otherActivityInput" <?php echo (!empty($other_activity)) ? '' : 'disabled'; ?> value="<?php echo htmlspecialchars($other_activity); ?>" />

                <!-- വ്യായാമം -->
                <h5 class="text-primary mt-4">🧘‍♀️ വ്യായാമം & ആരോഗ്യ ശീലങ്ങൾ</h5>
                <?php foreach ($exerciseOptions as $exercise): ?>
                    <div class="form-check <?php echo ($exercise == 'മറ്റുള്ളത്') ? 'mb-2' : ''; ?>">
                        <input type="checkbox" class="form-check-input exercise-checkbox" name="exercise_types[]" value="<?php echo $exercise; ?>" id="exercise_<?php echo $exercise; ?>" 
                            <?php echo ($exercise == 'മറ്റുള്ളത്') ? $exerciseOtherChecked : isChecked($exercise_types, $exercise); ?> />
                        <label class="form-check-label" for="exercise_<?php echo $exercise; ?>"><?php echo $exercise; ?></label>
                    </div>
                <?php endforeach; ?>
                <input type="text" class="form-control mb-3" name="other_exercise" placeholder="മറ്റുള്ളത്" id="otherExerciseInput" <?php echo (!empty($other_exercise)) ? '' : 'disabled'; ?> value="<?php echo htmlspecialchars($other_exercise); ?>" />

                <!-- Submit -->
                <div class="d-grid">
                    <button type="submit" class="btn btn-success btn-lg">✅ സമർപ്പിക്കുക</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- JavaScript -->
<script>
document.addEventListener("DOMContentLoaded", () => {
    function toggleOtherInput(checkboxId, inputId) {
        const checkbox = document.getElementById(checkboxId);
        const input = document.getElementById(inputId);
        function update() {
            if (checkbox.checked) {
                input.disabled = false;
                input.setAttribute("required", "required");
            } else {
                input.disabled = true;
                input.removeAttribute("required");
                input.value = "";
            }
        }
        checkbox.addEventListener("change", update);
        update();
    }
    toggleOtherInput("disease_മറ്റുള്ളത്", "otherDiseaseInput");
    toggleOtherInput("activity_മറ്റ്", "otherActivityInput");
    toggleOtherInput("exercise_മറ്റുള്ളത്", "otherExerciseInput");

    const medUseYes = document.getElementById("medUseYes");
    const medUseNo = document.getElementById("medUseNo");
    const medList = document.getElementById("medList");
    function updateMedList() {
        if (medUseYes.checked) {
            medList.disabled = false;
            medList.setAttribute("required", "required");
        } else {
            medList.disabled = true;
            medList.removeAttribute("required");
            medList.value = "";
        }
    }
    medUseYes.addEventListener("change", updateMedList);
    medUseNo.addEventListener("change", updateMedList);
    updateMedList();

    const hospitalVisitYes = document.getElementById("hospitalVisitYes");
    const hospitalVisitNo = document.getElementById("hospitalVisitNo");
    const hospitalDetails = document.getElementById("hospitalDetails");
    function updateHospitalDetails() {
        if (hospitalVisitYes.checked) {
            hospitalDetails.disabled = false;
            hospitalDetails.setAttribute("required", "required");
        } else {
            hospitalDetails.disabled = true;
            hospitalDetails.removeAttribute("required");
            hospitalDetails.value = "";
        }
    }
    hospitalVisitYes.addEventListener("change", updateHospitalDetails);
    hospitalVisitNo.addEventListener("change", updateHospitalDetails);
    updateHospitalDetails();
});

const ageInput = document.getElementById('ageInput');
ageInput.addEventListener('input', () => {
    if (ageInput.value.length > 3) {
        ageInput.value = ageInput.value.slice(0, 3);
    }
});
ageInput.addEventListener('keydown', (e) => {
    const allowedKeys = ['Backspace', 'ArrowLeft', 'ArrowRight', 'Delete', 'Tab'];
    if (allowedKeys.includes(e.key)) return;
    if (ageInput.value.length >= 3 && !allowedKeys.includes(e.key)) {
        e.preventDefault();
    }
});
</script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
<footer>
    <span>Powered by</span>
    <a href="https://workmateinfotech.com" target="_blank">
      <img src="https://workmateinfotech.com/images/Workmate_Infotech_Private_Limited____Logo_1_-0_1__1_-removebg-preview%201%20(2).png" alt="Workmate Infotech Logo">
    </a>
  </footer>
</body>
</html>
