<?php

error_reporting(1);

class CCAvenue_API
{
    /**
     * Execute api call in CCAvenue
     *
     * @return metting detials as xml
     */

    // Provide working key share by CCAvenues

    private $working_key = '9C513D88025FB423CFC647DFABF13172';

    // Provide access code Shared by CCAVENUES

    private $access_code = 'AVJH54MB77BL04HJLB';

    //Version Number
    private $version = '1.2';

    private $URL = 'https://api.ccavenue.com/apis/servlet/DoWebTrans';

    public function api_call($final_data)
    {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $this->URL);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_VERBOSE, 1);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $final_data);



        // Execute the curl request
        $result = curl_exec($ch);

        // Check for errors
        if (curl_errno($ch)) {
            //echo 'Curl error: ' . curl_error($ch);
        } else {
            //echo 'Response from CCAvenue: ' . $result; // Log full response
        }

        curl_close($ch);

        // Parse response
        $information = explode('&', $result);
        $dataSize    = sizeof($information);
        $status1     = explode('=', $information[0]);
        $status2     = explode('=', $information[1]);
        $status3     = explode('=', $information[2]);

        if ($status1[1] == '1') {
            return $status2[1] . ' Error Code: ' . $status3[1];
        } else {
            $status = $status2[1];

            return $status;
        }
    }


    public function orderStatusTracker($post_data)
    {
        /*
            function for get order status

        */
        $merchant_data = json_encode($post_data);

        /*
            sample $post_data after json encode

            {
               "reference_no": "225013271813",
               "order_no": "33231644"
            }
        */

        // Encrypt merchant data with working key shared by ccavenue



        $encrypted_data = self::encrypt($merchant_data, $this->working_key);



        //make final request string for the API call
        $command    = 'orderStatusTracker';
        $final_data = 'request_type=JSON&access_code=' . $this->access_code . '&command=' . $command . '&response_type=JSON&version=' . $this->version . '&enc_request=' . $encrypted_data;



        $result = self::api_call($final_data);


        return $result;
    }



    /*
    * @param1 : Plain String
    * @param2 : Working key provided by CCAvenue
    * @return : Decrypted String
    */
    public function encrypt($plainText, $key)
    {
        $key           = self::hextobin(md5($key));
        $initVector    = pack('C*', 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f);
        $openMode      = openssl_encrypt($plainText, 'AES-128-CBC', $key, OPENSSL_RAW_DATA, $initVector);
        $encryptedText = bin2hex($openMode);

        return $encryptedText;
    }

    /*
    * @param1 : Encrypted String
    * @param2 : Working key provided by CCAvenue
    * @return : Plain String
    */
    public function decrypt($encryptedText, $key)
    {
        $key           = self::hextobin(md5($key));
        $initVector    = pack('C*', 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f);
        $encryptedText = self::hextobin($encryptedText);
        $decryptedText = openssl_decrypt($encryptedText, 'AES-128-CBC', $key, OPENSSL_RAW_DATA, $initVector);

        return $decryptedText;
    }

    public function hextobin($hexString)
    {
        $length    = strlen($hexString);
        $binString = '';
        $count     = 0;
        while ($count < $length) {
            $subString    = substr($hexString, $count, 2);
            $packedString = pack('H*', $subString);

            if ($count == 0) {
                $binString = $packedString;
            } else {
                $binString .= $packedString;
            }

            $count += 2;
        }

        return $binString;
    }
}
