<?php

function post_sales_account($data)
{
    $sales_guid    = $data['sales_guid'];
    $tvalue        = $data['taxable_value'];
    $paid_amount   = $data['paid_amount'];
    $customer_guid = (int) $data['customer_guid'];
    $discount      = $data['discount'];

    //$voucher_date = date('Y-m-d');
    if ($data['payment_date']) {
        $voucher_date = date('Y-m-d', strtotime($data['payment_date']));
    } else {
        $voucher_date = date('Y-m-d');
    }
    $editid = $data['data']['editid'];

    //$narration = $data['narration'];
    if ($tvalue) {
        $customers = customer_ledger($customer_guid);
        //first entery
        $post['acc_type']     = 2;
        $post['parent_guid']  = $customer_guid;
        $post['ledger_guid']  = 28;
        $post['vouchertype']  = 4;
        $post['voucherno']    = $sales_guid;
        $post['dr']           = 0;
        $post['cr']           = $tvalue;
        $post['narration']    = $sales_guid;
        $post['voucher_date'] = $voucher_date;
        account_post($post);

        //customer account
        if ($customers) {
            $post['ledger_guid']  = $customers['id'];
            $post['vouchertype']  = 4;
            $post['voucherno']    = $sales_guid;
            $post['dr']           = $tvalue;
            $post['cr']           = 0;
            $post['voucher_date'] = $voucher_date;
            account_post($post);
        }

        if ($editid) {
            updateQuery("update ca_accounts set voucher_date = '$voucher_date' where voucherno = '$editid' and vouchertype=7");
        }
    }
}


function invoice_recieved_post($data)
{
    $vouchertype      = 7;
    $post['acc_type'] = 2;
    $latefee          = $data['latefee'];
    $voucherno        = $data['voucherno'];
    $customer_guid    = $data['customer_guid'];
    $paid_amount      = $data['recieved'];
    $discount         = $data['discount'];
    $add_amount       = $data['add_amount'];
    $payment_type     = $data['payment_method'];
    $customers        = customer_ledger($customer_guid);

    if ($data['payment_date']) {
        $voucher_date = date('Y-m-d', strtotime($data['payment_date']));
    } else {
        $voucher_date = date('Y-m-d');
    }

    $ledger_guid         = 30;
    $post['parent_guid'] = $customer_guid;

    //latefee
    if ($latefee) {
        $post['ledger_guid']  = $customers['id'];
        $post['vouchertype']  = 11;
        $post['voucherno']    = $voucherno;
        $post['cr']           = 0;
        $post['dr']           = $latefee;
        $post['voucher_date'] = $voucher_date;
        account_post($post);

        $post['ledger_guid']  = 32;
        $post['vouchertype']  = 11;
        $post['voucherno']    = $voucherno;
        $post['dr']           = 0;
        $post['cr']           = $latefee;
        $post['voucher_date'] = $voucher_date;
        account_post($post);
    }
    //customer
    $post['narration'] = $data['narration'];

    if ($customers) {
        $post['ledger_guid']  = $customers['id'];
        $post['vouchertype']  = $vouchertype;
        $post['voucherno']    = $voucherno;
        $post['cr']           = $paid_amount;
        $post['dr']           = 0;
        $post['voucher_date'] = $voucher_date;
        account_post($post);
    }

    //dr account
    if ($paid_amount) {
        $post['ledger_guid']  = $ledger_guid;
        $post['vouchertype']  = $vouchertype;
        $post['voucherno']    = $voucherno;
        $post['cr']           = 0;
        $post['dr']           = $paid_amount;
        $post['voucher_date'] = $voucher_date;
        account_post($post);
    }

    //discount
    if ($discount) {
        $post['ledger_guid']  = 31;
        $post['vouchertype']  = 4;
        $post['voucherno']    = $voucherno;
        $post['dr']           = $discount;
        $post['cr']           = 0;
        $post['voucher_date'] = $voucher_date;
        account_post($post);

        $post['ledger_guid']  = $customers['id'];
        $post['vouchertype']  = 4;
        $post['voucherno']    = $voucherno;
        $post['dr']           = 0;
        $post['cr']           = $discount;
        $post['voucher_date'] = $voucher_date;
        account_post($post);
    }

    //add amount
    if ($add_amount) {
        $addledger            = add_ledger();
        $post['narration']    = annotation('account_receipt', true) + 1;
        $post['ledger_guid']  = $addledger['id'];
        $post['vouchertype']  = 8;
        $post['voucherno']    = $voucherno;
        $post['dr']           = 0;
        $post['cr']           = $add_amount;
        $post['voucher_date'] = $voucher_date;
        $addid                = account_post($post);

        $post['ledger_guid']  = 30;
        $post['vouchertype']  = 8;
        $post['voucherno']    = $voucherno;
        $post['dr']           = $add_amount;
        $post['cr']           = 0;
        $post['voucher_date'] = $voucher_date;
        $post['child_guid']   = $addid;
        account_post($post);

        $post['ledger_guid']  = $customers['id'];
        $post['vouchertype']  = 4;
        $post['voucherno']    = $voucherno;
        $post['dr']           = $add_amount;
        $post['cr']           = 0;
        $post['voucher_date'] = $voucher_date;
        account_post($post);
    }
}

function add_ledger()
{
    $ledger = findQuery("select id,title from ca_account_groups where  	parent_guid = 29 and title = 'Additional Charges' limit 1");

    if ($ledger) {
        return $ledger[0];
    } else {
        //$customer = findQuery("select name from ca_customer where id=$customer_guid");
        $ledger['title']          = 'Additional Charges';
        $ledger['customer_guid']  = 0;
        $ledger['parent_guid']    = 29;
        $ledger['default_ledger'] = 1;
        $ledger['ledger']         = 1;
        $id                       = saveArray('ca_account_groups', $ledger, 0);
        $ledger['id']             = $id;

        return $ledger;
    }
}


function customer_ledger($customer_guid)
{
    $ledger = findQuery("select id,title from ca_account_groups where  	customer_guid = $customer_guid limit 1");

    if ($ledger) {
        return $ledger[0];
    } else {
        $customer                 = findQuery("select name from ca_customer where id=$customer_guid");
        $ledger['title']          = $customer[0]['name'];
        $ledger['customer_guid']  = $customer_guid;
        $ledger['parent_guid']    = 9;
        $ledger['default_ledger'] = 1;
        $ledger['ledger']         = 1;
        $id                       = saveArray('ca_account_groups', $ledger, 0);
        $ledger['id']             = $id;

        return $ledger;
    }
}

function vendor_ledger($vendor_guid)
{
    $ledger = findQuery("select id,title from ca_account_groups where vendor_guid = $vendor_guid limit 1");

    if ($ledger) {
        return $ledger[0];
    } else {
        $vendor                   = findQuery("select title from ca_vendors where id=$vendor_guid");
        $ledger['title']          = $vendor[0]['title'];
        $ledger['vendor_guid']    = $vendor_guid;
        $ledger['parent_guid']    = 18;
        $ledger['default_ledger'] = 1;
        $ledger['ledger']         = 1;
        $id                       = saveArray('ca_account_groups', $ledger, 0);
        $ledger['id']             = $id;

        return $ledger;
    }
}

function account_post($data)
{
    if (!$data['ledger_guid']) {
        return;
    }
    $id          = (int) $data['id'];
    $ledgerguid  = (int) $data['ledger_guid'];
    $vouchertype = (int) $data['vouchertype'];
    $voucherno   = (int) $data['voucherno'];

    $were          = "  	vouchertype = '$vouchertype' and voucherno = '$voucherno' and ledger_guid = '$ledgerguid' ";
    $previous_post = findQuery("select id from ca_accounts where $were ");

    if ($previous_post) {
        $id = (int) $previous_post[0]['id'];
    }

    $account['ledger_guid']  = $data['ledger_guid'];
    $account['vouchertype']  = (int) $data['vouchertype'];
    $account['parent_guid']  = (int) $data['parent_guid'];
    $account['voucherno']    = (int) $data['voucherno'];
    $account['voucher_date'] = $data['voucher_date'];
    $account['narration']    = $data['narration'];
    $account['acc_type']     = (int) $data['acc_type'];
    $account['child_guid']   = (int) $data['child_guid'];

    if ($data['dr']) {
        $account['dr'] = $data['dr'];
    }

    if ($data['cr']) {
        $account['cr'] = $data['cr'];
    }
    $account['owner_guid'] = owner_guid();
    $id                    = saveArray('ca_accounts', $account, $id);

    return $id;
}


function invoice_payment_post($data)
{
    $id               = $data['id'];
    $vouchertype      = 6;
    $post['acc_type'] = 1;
    $vendor_guid      = $data['vendor_guid'];
    $narration        = $data['narration'];
    $paid_amount      = $data['paid_amount'];
    $return_guid      = $data['return_guid'];

    if ($return_guid) {
        $vouchertype = 7;
        //$post['acc_type'] = 2;
    }
    $payment_type = $data['payment_method'];
    $vendors      = vendor_ledger($vendor_guid);

    if ($data['payment_date']) {
        $voucher_date = date('Y-m-d', strtotime($data['payment_date']));
    } else {
        $voucher_date = date('Y-m-d');
    }

    if ($payment_type == 1) {
        $ledger_guid = 30;
    } else {
        $ledger_guid = $payment_type;
    }
    //cr account
    $post['narration'] = $data['narration'];

    if ($vendors) {
        $post['parent_guid'] = $vendor_guid;
        $post['narration']   = $narration;
        $post['ledger_guid'] = $vendors['id'];
        $post['vouchertype'] = $vouchertype;
        $post['voucherno']   = $id;

        if ($return_guid) {
            $post['dr'] = 0;
            $post['cr'] = $paid_amount;
        } else {
            $post['cr'] = 0;
            $post['dr'] = $paid_amount;
        }

        $post['voucher_date'] = $voucher_date;
        account_post($post);
    }

    //dr account
    if ($payment_type) {
        $post['ledger_guid'] = $ledger_guid;
        $post['vouchertype'] = $vouchertype;
        $post['voucherno']   = $id;

        if ($return_guid) {
            $post['dr'] = $paid_amount;
            $post['cr'] = 0;
        } else {
            $post['cr'] = $paid_amount;
            $post['dr'] = 0;
        }

        $post['voucher_date'] = $voucher_date;
        account_post($post);
    }
}


function invoice_receipt_post($data)
{
    $vouchertype   = 7;
    $id            = $data['id'];
    $customer_guid = $data['customer_guid'];
    $paid_amount   = $data['paid_amount'];
    $return_guid   = $data['return_guid'];
    $payment_type  = $data['payment_method'];
    $customer      = customer_ledger($customer_guid);

    if ($return_guid) {
        $vouchertype = 6;
    }

    if ($data['payment_date']) {
        $voucher_date = date('Y-m-d', strtotime($data['payment_date']));
    } else {
        $voucher_date = date('Y-m-d');
    }

    if ($payment_type == 1) {
        $ledger_guid = 30;
    } else {
        $ledger_guid = $payment_type;
    }

    //cr account
    if ($customer) {
        $post['ledger_guid'] = $customer['id'];
        $post['vouchertype'] = $vouchertype;
        $post['voucherno']   = $id;

        if ($return_guid) {
            $post['dr'] = 0;
            $post['cr'] = $paid_amount;
        } else {
            $post['cr'] = 0;
            $post['dr'] = $paid_amount;
        }

        $post['voucher_date'] = $voucher_date;
        account_post($post);
    }

    //dr account
    if ($payment_type) {
        $post['ledger_guid'] = $ledger_guid;
        $post['vouchertype'] = $vouchertype;
        $post['voucherno']   = $id;

        if ($return_guid) {
            $post['dr'] = $paid_amount;
            $post['cr'] = 0;
        } else {
            $post['cr'] = $paid_amount;
            $post['dr'] = 0;
        }

        $post['voucher_date'] = $voucher_date;
        account_post($post);
    }
}


function create_default_ledger()
{
}
