<?php

if (isset($option)) {
    if (isset($option['reading'])) {
        sms_reading($option['data']);
    }

    if (isset($option['billing'])) {
        sms_bill($option['data']);
    }
}

function sms($data)
{
    $settings = findQuery('select sms_api_key,sms_api_from from ca_settings limit 1');
    $api_key  = $settings[0]['sms_api_key'];
    $from     = $settings[0]['sms_api_from'];

    if (!$api_key) {
        return false;
    }
    $contacts = implode(',', $data['to']);//'97656XXXXX,98012XXXXX';
    $sms_text = urlencode($data['sms']);
    $api_url  = 'http://sms.nexapps.in/app/smsapi/index.php?key=' . $api_key . '&campaign=0&routeid=45&type=text&contacts=' . $contacts . '&senderid=' . $from . '&msg=' . $sms_text;
    //Submit to server
    $response = file_get_contents($api_url);

    return $response;
}
function sms_reading($data)
{
    $settings      = findQuery('select header from ca_settings limit 1');
    $header        = $settings[0]['header'];
    $reading       = $data['reading'];
    $customer_guid = (int) $data['customer_guid'];
    $customer      = findQuery("select consumer_no,name,mobile from ca_customer where id=$customer_guid");
    $no            = $customer[0]['consumer_no'];
    $name          = $customer[0]['name'];
    $mobile        = $customer[0]['mobile'];

    $date             = date('d-m-y');
    $invoice          = $data['id'];
    $previous_balance = $data['previous_balance'];
    $min_rent         = $data['min_rent'];
    $recieved         = $data['recieved'];
    $balance          = $data['balance'];
    $usage_amount     = $data['usage_amount'];
    $last_reading     = $data['last_reading'];
    $usage            = $reading - $last_reading;
    $msg              = $header . "\n $date\n Inv No: $invoice\n $name ($no)\n Usage: $usage\n Min Rent: Rs$min_rent\n Usg Amt.: Rs$usage_amount\n P. Bal: Rs$previous_balance\n Rec.:Rs$recieved\n Bal.:Rs$balance";
    $to               = [0 => $mobile];
    $info['to']       = $to;
    $info['sms']      = $msg;
    $rs               = sms($info);
}


function sms_bill($data)
{
    $settings      = findQuery('select header from ca_settings limit 1');
    $header        = $settings[0]['header'];
    $reading       = $data['reading'];
    $customer_guid = (int) $data['customer_guid'];
    $customer      = findQuery("select consumer_no,name,mobile from ca_customer where id=$customer_guid");
    $no            = $customer[0]['consumer_no'];
    $name          = $customer[0]['name'];
    $mobile        = $customer[0]['mobile'];

    $date     = date('d-m-y');
    $invoice  = $data['id'];
    $lf       = $data['latefee'];
    $recieved = $data['recieved'];
    $balance  = $data['balance'];
    $amount   = $data['amount'];
    $dis      = $data['discount'];

    $msg         = $header . " \n $date\n Bill No: $invoice\n $name ($no)\nAmt: Rs.$amount\nL. Fee: Rs.$lf\nDiscount: Rs.$dis\nReceived: Rs.$recieved\nBalance: Rs.$balance";
    $to          = [0 => $mobile];
    $info['to']  = $to;
    $info['sms'] = $msg;
    $rs          = sms($info);
}
