<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
 <link rel="apple-touch-icon" sizes="180x180" href="/apple-touch-icon.png">
<link rel="icon" type="image/png" sizes="32x32" href="/favicon-32x32.png">
<link rel="icon" type="image/png" sizes="16x16" href="/favicon-16x16.png">
<link rel="manifest" href="/site.webmanifest">
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>Path Finder</title>
  <style>
    body {
      margin: 0;
      padding: 0;
      background-color: #000;
      display: flex;
      justify-content: center;
      align-items: center;
      height: 100vh;
      flex-direction: column;
      color: white;
      font-family: Arial, sans-serif;
      position: relative;
       background: linear-gradient(rgba(0, 0, 0, 0.7), rgba(0, 0, 0, 0.7)),
                  url('fb1c39f459d6727cb164eb106f3fe298.jpg') no-repeat center center fixed;
      background-size: cover;
    }

    #splashImage {
      max-width: 100%;
      max-height: 100%;
      object-fit: contain;
      display: none; /* Hidden until loaded */
    }

    #loaderContainer {
      display: flex;
      flex-direction: column;
      align-items: center;
    }

    .loader {
      width: 60px;
      height: 60px;
      border: 6px solid transparent;
      border-top: 6px solid #f44336;   /* Red */
      border-right: 6px solid #2196f3; /* Blue */
      border-bottom: 6px solid #4caf50; /* Green */
      border-left: 6px solid #ffeb3b;  /* Yellow */
      border-radius: 50%;
      animation: spin 1.2s linear infinite;
      margin-bottom: 15px;
    }

    @keyframes spin {
      0% { transform: rotate(0deg); }
      100% { transform: rotate(360deg); }
    }

    #loadingText {
      font-size: 1.2rem;
      text-align: center;
    }
  </style>
</head>
<body>

  <div id="loaderContainer">
    <div class="loader"></div>
    <div id="loadingText">Loading...</div>
  </div>

  <img id="splashImage" src="WhatsApp Image 2025-08-09 at 15.41.41_ceb181eb.jpg" alt="Path Finder" />

  <script>
    const img = document.getElementById('splashImage');
    const loaderContainer = document.getElementById('loaderContainer');

    img.onload = function () {
      loaderContainer.style.display = 'none'; // Hide spinner + text
      img.style.display = 'block';            // Show image

      setTimeout(function () {
        window.location.href = "register.php";
      }, 5000); // Redirect after 5 seconds
    };

    img.onerror = function () {
      document.getElementById('loadingText').innerText = "Failed to load image.";
      // Optional fallback redirect
      setTimeout(function () {
        window.location.href = "register.php";
      }, 5000);
    };
  </script>
</body>
</html>