<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <title>Status</title>
  <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" />
  <style>
    body {
      background-color: #f0f8ff; /* AliceBlue */
    }
    .modal-content {
      background-color: #e6f0ff; /* light pastel blue */
    }
    .modal-header.success {
      background-color: #004085 !important; /* dark blue */
      color: white;
    }
    .modal-header.error { /* Custom class for error header */
      background-color: #dc3545 !important; /* Bootstrap's danger red */
      color: white;
    }
    .modal-footer .btn-success {
      background-color: #004085;
      border-color: #004085;
    }
    .modal-footer .btn-danger {
      background-color: #dc3545;
      border-color: #dc3545;
    }
  </style>
</head>
<body>

<?php
$status            = $_GET['status'] ?? ''; // Get status, default to empty string if not set
$is_saved          = ($status == 'saved');
$is_duplicate_name = ($status == 'duplicate_name');

if ($is_saved || $is_duplicate_name):
    ?>
<div class="modal fade" id="statusModal" tabindex="-1" role="dialog" aria-labelledby="statusModalLabel" aria-hidden="true" data-backdrop="static">
  <div class="modal-dialog modal-dialog-centered" role="document">
    <div class="modal-content <?php echo $is_saved ? 'border-success' : 'border-danger'; ?>">
      <div class="modal-header <?php echo $is_saved ? 'success' : 'error'; ?>">
        <h5 class="modal-title" id="statusModalLabel">
          <?php echo $is_saved ? 'Success' : 'Error'; ?>
        </h5>
        <button type="button" class="close text-white" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <?php if ($is_saved): ?>
          Your response has been <strong>saved successfully</strong>! &#127881;
        <?php elseif ($is_duplicate_name): ?>
          <strong class="text-danger">Error:</strong> Registration with this name already exists. Please check the name and try again. &#10060;
        <?php endif; ?>
      </div>
      <div class="modal-footer">
        <button type="button" id="okBtn" class="btn <?php echo $is_saved ? 'btn-success' : 'btn-danger'; ?>" data-dismiss="modal">OK</button>
      </div>
    </div>
  </div>
</div>
<?php endif; ?>

<!-- jQuery and Bootstrap JS -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>

<?php if ($is_saved || $is_duplicate_name): ?>
<script>
$(document).ready(function() {
    $('#statusModal').modal('show');

    $('#okBtn').on('click', function() {
        // Redirect to the homepage after clicking OK
        window.location.href = 'http://pathfinder.mlavallikkunnu.in/';
    });

    // Optional: clear status param from URL on page load
    if (window.history.replaceState) {
        const url = new URL(window.location);
        url.searchParams.delete('status');
        window.history.replaceState({}, document.title, url.toString());
    }
});
</script>
<?php endif; ?>

</body>
</html>
