CREATE TABLE `ca_receipt` (
  `id` int NOT NULL AUTO_INCREMENT,
  `userid` int NOT NULL DEFAULT '0',
  `amount` float NOT NULL DEFAULT '0',
  `payable` decimal(10,2) NOT NULL DEFAULT '0.00',
  `send_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `orderid` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `transid` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;



CREATE TABLE `settings` (
  `id` int NOT NULL,
  `version` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `Startdate` datetime NOT NULL,
  `hide` int NOT NULL DEFAULT '0',
  `enddate` datetime NOT NULL DEFAULT '2000-01-01 00:00:00',
  `hideforappstore` int NOT NULL DEFAULT '0',
  `isRazorpaymentgateway` int NOT NULL DEFAULT '0',
  `showdistrict_assembly` int NOT NULL DEFAULT '1',
  `playstore_url` varchar(500) COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `appstore_url` varchar(500) COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO settings VALUES('1', '3', '2025-01-20 00:00:00', '0', '2026-01-20 00:00:00', '3', '2', '0', 'https://play.google.com/store/apps/details?id=com.shadekadappadi.moneypool', 'https://apps.apple.com/in/app/shade-kadappadi/id6569244236');


CREATE TABLE `tbl_assembly` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `district` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=103 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO tbl_assembly VALUES('10', 'Vengara', '1', '0');
INSERT INTO tbl_assembly VALUES('9', 'Kondotty', '1', '0');
INSERT INTO tbl_assembly VALUES('1', 'Vallikkunnu', '1', '0');
INSERT INTO tbl_assembly VALUES('102', 'NA', '1', '0');
INSERT INTO tbl_assembly VALUES('15', 'Tirurangadi', '1', '0');
INSERT INTO tbl_assembly VALUES('16', 'Kottakkal', '1', '0');


CREATE TABLE `tbl_challenge` (
  `id` int NOT NULL AUTO_INCREMENT,
  `challenge_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `challenge_image` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `challenge_startdate` date NOT NULL DEFAULT '1990-01-01',
  `challenge_enddate` date NOT NULL DEFAULT '1990-01-01',
  `location` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `description` varchar(5000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `product_name1` char(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `product_image1` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `product_amount1` float NOT NULL DEFAULT '0',
  `productconversion1` int NOT NULL DEFAULT '1',
  `delivary_date1` date NOT NULL DEFAULT '1990-01-01',
  `product_name2` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `product_image2` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `product_amount2` float NOT NULL DEFAULT '0',
  `productconversion2` int NOT NULL DEFAULT '1',
  `delivary_date2` date NOT NULL DEFAULT '1990-01-01',
  `product_name3` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `product_image3` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `product_amount3` float NOT NULL DEFAULT '0',
  `productconversion3` int NOT NULL DEFAULT '1',
  `delivary_date3` date DEFAULT '1990-01-01',
  `sponsorproductid1` int NOT NULL DEFAULT '0',
  `sponsorproductid2` int NOT NULL DEFAULT '0',
  `sponsorproductid3` int NOT NULL DEFAULT '0',
  `sponsorproductid4` int NOT NULL DEFAULT '0',
  `sponsorproductid5` int NOT NULL DEFAULT '0',
  `rate1` decimal(10,2) NOT NULL DEFAULT '0.00',
  `rate2` decimal(10,2) NOT NULL DEFAULT '0.00',
  `rate3` decimal(10,2) NOT NULL DEFAULT '0.00',
  `rate4` decimal(10,2) NOT NULL DEFAULT '0.00',
  `rate5` decimal(10,2) NOT NULL DEFAULT '0.00',
  `unit` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `status` int NOT NULL DEFAULT '0',
  `showdistrictandassembly` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO tbl_challenge VALUES('1', 'Biriyani Challenge', 'Dashboard.jpg', '2024-07-01', '2026-08-16', 'kadappadi,Malappuram,Kerala 676122', 'à´•àµˆà´•àµ‹àµ¼à´•àµà´•à´¾à´‚ à´¨à´®àµà´•àµà´•àµ
à´ªà´¾à´µà´ªàµà´ªàµ†à´Ÿàµà´Ÿ à´•à´¿à´¡àµà´¨à´¿ à´°àµ‹à´—à´¿à´•àµ¾à´•àµà´•à´¾à´¯àµ !

à´ªàµà´°à´¿à´¯à´ªàµà´ªàµ†à´Ÿàµà´Ÿà´µà´°àµ‡....

à´·àµ†à´¯àµà´¡àµ à´ªàµ‚à´•àµà´•àµ‹à´¯ à´¤à´™àµà´™àµ¾ à´¡à´¯à´¾à´²à´¿à´¸à´¿à´¸àµ à´¸àµ†àµ»àµà´±àµ¼ à´¸àµ‹à´«àµà´±àµà´±àµ à´²àµ‹à´žàµà´šà´¿à´‚à´—àµ à´•à´´à´¿à´žàµà´žàµ à´°àµ‹à´—à´¿à´•à´³àµ† à´ªàµà´°à´µàµ‡à´¶à´¿à´ªàµà´ªà´¿à´šàµà´šàµ à´¤àµà´Ÿà´™àµà´™à´¿à´¯à´¿à´°à´¿à´•àµà´•àµà´•à´¯à´¾à´£àµ. à´¸àµ—à´œà´¨àµà´¯ à´¡à´¯à´¾à´²à´¿à´¸à´¿à´¸àµ à´ªàµà´°à´•àµà´°à´¿à´¯ à´®àµà´¨àµà´¨àµ‹à´Ÿàµà´Ÿàµ à´•àµŠà´£àµà´Ÿàµà´ªàµ‹à´•àµà´¨àµà´¨à´¤à´¿à´¨àµ  à´‡à´¨à´¿à´¯àµà´‚ à´¨à´¿à´™àµà´™à´³àµà´Ÿàµ†à´¯àµ†à´²àµà´²à´¾à´‚ à´¸à´¹à´¾à´¯à´™àµà´™àµ¾ à´†à´µà´¶àµà´¯à´®à´¾à´£àµ. 2024 à´†à´—à´¸àµà´±àµà´±àµ 15 à´¨àµ à´·àµ†à´¯àµà´¡àµ à´¨à´¾à´²à´¾à´®à´¤àµ à´¬à´¿à´°à´¿à´¯à´¾à´£à´¿ à´šà´²à´žàµà´šàµ à´¸à´‚à´˜à´Ÿà´¿à´ªàµà´ªà´¿à´•àµà´•àµà´•à´¯à´¾à´£àµ. à´¨à´®àµà´®àµà´Ÿàµ† à´‡à´·àµà´Ÿ à´­à´•àµà´·à´£à´¤àµà´¤àµ‹à´ŸàµŠà´ªàµà´ªà´‚ à´’à´°àµ à´°àµ‹à´—à´¿à´¯àµ† à´Žà´™àµà´•à´¿à´²àµà´‚ à´¨à´®àµà´•àµà´•àµ à´šàµ‡àµ¼à´¤àµà´¤àµ à´ªà´¿à´Ÿà´¿à´•àµà´•à´¾à´‚!
à´•à´´à´¿à´žàµà´ž à´µàµ¼à´·à´™àµà´™à´³à´¿àµ½ à´¨à´®àµà´®àµ¾ à´’à´°àµà´®à´¿à´šàµà´šàµ à´…à´µà´¿à´¸àµà´®à´°à´£àµ€à´¯à´®à´¾à´•àµà´•à´¯à´¤à´¾à´£àµ. à´‡à´¤àµà´¤à´µà´£à´¯àµà´‚ à´ªà´¤à´¿à´µàµ à´¤àµ†à´±àµà´±à´¾à´¤àµ† à´•àµ‚à´Ÿàµ†à´¯àµà´£àµà´Ÿà´¾à´•àµà´®àµ†à´¨àµà´¨ à´ªàµà´°à´¤àµ€à´•àµà´·à´¯àµ‹à´Ÿàµ†,

à´Ÿàµ€à´‚ à´·àµ†à´¯àµà´¡àµ à´šà´¾à´°à´¿à´±àµà´±à´¿ à´¸àµ†àµ½, à´•à´¾à´Ÿà´ªàµà´ªà´Ÿà´¿', 'Chicken Biriyaani', 'Chicken Biryani.jpg', '100', '1', '2024-05-20', 'Beef Biriyaani', 'KuttanBiryani.jpg', '1000', '10', '2024-05-21', '', '', '0', '1', '2024-05-22', '1', '2', '0', '0', '0', '3000.00', '200.00', '0.00', '0.00', '0.00', 'Packets', '0', '0');


CREATE TABLE `tbl_club` (
  `id` int NOT NULL AUTO_INCREMENT,
  `club_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO tbl_club VALUES('1', 'OSCAR KAKKATHADAM', '0');
INSERT INTO tbl_club VALUES('2', 'ORUMA ALAKKAPARAMB', '0');
INSERT INTO tbl_club VALUES('3', 'msf k k padi', '0');
INSERT INTO tbl_club VALUES('4', 'farook college calicut', '0');
INSERT INTO tbl_club VALUES('5', 'FASAL SHADE ', '0');
INSERT INTO tbl_club VALUES('6', 'VYAPARI VYVASAYI PADIKKAL', '0');
INSERT INTO tbl_club VALUES('7', 'farook college kottakkal ', '0');
INSERT INTO tbl_club VALUES('8', 'P P T M COLLEGE CHERUR', '0');
INSERT INTO tbl_club VALUES('9', 'kamarudheen kadappadi', '0');


CREATE TABLE `tbl_customer` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `Address` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `Mobile` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `District` int NOT NULL DEFAULT '0',
  `Assembly` int NOT NULL DEFAULT '0',
  `Panchayat` int NOT NULL DEFAULT '0',
  `Ward` int NOT NULL DEFAULT '0',
  `Photo` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=29 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO tbl_customer VALUES('1', 'Faizal', '', '', '1', '1', '68', '1403', '');
INSERT INTO tbl_customer VALUES('2', 'fasal shade c/o', '', '7902498861', '1', '102', '123', '2315', '');
INSERT INTO tbl_customer VALUES('3', 'vyapari padikkal c/o', '', '', '1', '102', '123', '2315', '');
INSERT INTO tbl_customer VALUES('4', 'shukoor', '', '9947553324', '1', '102', '123', '2315', '');
INSERT INTO tbl_customer VALUES('5', 'shamil ap', '', '8547362136', '1', '102', '123', '2315', '');
INSERT INTO tbl_customer VALUES('6', 'Hussan kutty bapu', '', '', '1', '1', '68', '1403', '');
INSERT INTO tbl_customer VALUES('7', 'Kuttippa', '', '', '1', '1', '68', '1403', '');
INSERT INTO tbl_customer VALUES('8', 'Hassain PC', '', '', '1', '1', '68', '1403', '');
INSERT INTO tbl_customer VALUES('9', 'Gafoor kaku', '', '', '1', '1', '68', '1403', '');
INSERT INTO tbl_customer VALUES('10', 'Shareef', '', '', '1', '1', '68', '1403', '');
INSERT INTO tbl_customer VALUES('11', 'younus', '', '', '1', '1', '68', '1403', '');
INSERT INTO tbl_customer VALUES('12', 'Salam PC', '', '', '1', '1', '68', '1403', '');
INSERT INTO tbl_customer VALUES('13', 'Liyakhath ', '', '', '1', '1', '68', '1403', '');
INSERT INTO tbl_customer VALUES('14', 'Jaleel pc', '', '', '1', '1', '68', '1403', '');
INSERT INTO tbl_customer VALUES('15', 'Saidalavi kaka kolappuram', '', '', '1', '1', '68', '1403', '');
INSERT INTO tbl_customer VALUES('16', 'Rafi mannarcheeri', '', '', '1', '1', '68', '1403', '');
INSERT INTO tbl_customer VALUES('17', 'Davood mannarcheeri ', '', '', '1', '1', '68', '1403', '');
INSERT INTO tbl_customer VALUES('18', 'Mannarcheeri tharavad', '', '', '1', '1', '68', '1403', '');
INSERT INTO tbl_customer VALUES('19', 'Basheer kolappuram ', '', '', '1', '1', '68', '1403', '');
INSERT INTO tbl_customer VALUES('20', 'Salam PC', '', '', '1', '1', '68', '1403', '');
INSERT INTO tbl_customer VALUES('21', 'Muhammed Ali pc', '', '', '1', '1', '68', '1403', '');
INSERT INTO tbl_customer VALUES('22', 'Hameed chokly', '', '', '1', '1', '68', '1403', '');
INSERT INTO tbl_customer VALUES('23', 'Saidalavi malayil', '', '', '1', '1', '68', '1403', '');
INSERT INTO tbl_customer VALUES('24', 'Khader malayil', '', '', '1', '1', '68', '1403', '');
INSERT INTO tbl_customer VALUES('25', 'Fuvad PC', '', '', '1', '1', '68', '1403', '');


CREATE TABLE `tbl_district` (
  `id` int NOT NULL AUTO_INCREMENT,
  `district_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO tbl_district VALUES('1', 'Malappuram', '0');


CREATE TABLE `tbl_panchayat` (
  `id` int NOT NULL AUTO_INCREMENT,
  `assembly_id` int NOT NULL DEFAULT '0',
  `panchayat_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=124 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO tbl_panchayat VALUES('1', '10', 'Abdu Rahiman Nagar', '0');
INSERT INTO tbl_panchayat VALUES('11', '1', 'Chelembra', '0');
INSERT INTO tbl_panchayat VALUES('109', '9', 'Vazhakkad', '0');
INSERT INTO tbl_panchayat VALUES('27', '10', 'Kannamangalam', '0');
INSERT INTO tbl_panchayat VALUES('34', '9', 'Kondotty Muncipality', '0');
INSERT INTO tbl_panchayat VALUES('36', '16', 'Kottakkal', '0');
INSERT INTO tbl_panchayat VALUES('49', '1', 'Moonniyur', '0');
INSERT INTO tbl_panchayat VALUES('61', '1', 'Pallikkal', '0');
INSERT INTO tbl_panchayat VALUES('68', '1', 'Peruvallur', '0');
INSERT INTO tbl_panchayat VALUES('85', '1', 'Thenhipalam', '0');
INSERT INTO tbl_panchayat VALUES('123', '102', 'NA', '0');
INSERT INTO tbl_panchayat VALUES('122', '16', 'Kottakkal Muncipality ', '0');
INSERT INTO tbl_panchayat VALUES('121', '15', 'Perumanna klari', '0');
INSERT INTO tbl_panchayat VALUES('120', '15', 'Edarikkode', '0');
INSERT INTO tbl_panchayat VALUES('119', '15', 'Thennala', '0');
INSERT INTO tbl_panchayat VALUES('93', '15', 'Tirurangadi muncipality', '0');
INSERT INTO tbl_panchayat VALUES('118', '15', 'Nannambra', '0');
INSERT INTO tbl_panchayat VALUES('97', '1', 'Vallikkunnu', '0');
INSERT INTO tbl_panchayat VALUES('117', '15', 'Parappanagadi Muncipality', '0');
INSERT INTO tbl_panchayat VALUES('116', '10', 'Othukkunagal', '0');
INSERT INTO tbl_panchayat VALUES('115', '10', 'Parappur', '0');
INSERT INTO tbl_panchayat VALUES('114', '10', 'Oorakam', '0');
INSERT INTO tbl_panchayat VALUES('113', '9', 'Muthuvallur', '0');
INSERT INTO tbl_panchayat VALUES('103', '10', 'Vengara', '0');
INSERT INTO tbl_panchayat VALUES('112', '9', 'Cheekode', '0');
INSERT INTO tbl_panchayat VALUES('111', '9', 'Cherukavu', '0');
INSERT INTO tbl_panchayat VALUES('110', '9', 'Pulikkal ', '0');
INSERT INTO tbl_panchayat VALUES('108', '9', 'Vazhayur ', '0');


CREATE TABLE `tbl_product` (
  `id` int NOT NULL AUTO_INCREMENT,
  `product_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `amount` float NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO tbl_product VALUES('1', 'Rice', '3000', '0');
INSERT INTO tbl_product VALUES('2', 'Chicken', '200', '0');


CREATE TABLE `tbl_transaction` (
  `id` int NOT NULL AUTO_INCREMENT,
  `donation` int NOT NULL DEFAULT '0',
  `sponsorship` int NOT NULL DEFAULT '0',
  `challengeid` int NOT NULL DEFAULT '0',
  `clubid` int NOT NULL DEFAULT '0',
  `hideidendity` int NOT NULL DEFAULT '0',
  `customerid` int NOT NULL DEFAULT '0',
  `orderforothers` int NOT NULL DEFAULT '0',
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `address` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `mobile` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `dateadded` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `Transid` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `orderid` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `Amount` decimal(10,2) NOT NULL DEFAULT '0.00',
  `Received` decimal(10,2) NOT NULL DEFAULT '0.00',
  `volunteer` int NOT NULL DEFAULT '0',
  `status` int NOT NULL DEFAULT '0',
  `uniquedid` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `is_Razor_payment_gateway` int NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=29 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO tbl_transaction VALUES('1', '0', '0', '1', '0', '0', '1', '0', '', '', '', '2025-08-08 11:09:50', '', '', '100.00', '0.00', '4', '0', 'e31cde63c8b6222bf781ddb5b6064ce9f369b33fe4d93b043db0582fa3132e64', '2');
INSERT INTO tbl_transaction VALUES('2', '0', '0', '1', '0', '0', '2', '0', '', '', '', '2025-08-09 08:50:55', '', '', '5000.00', '5000.00', '11', '0', 'b049d3e2f027453c1a7d8400473e0ec2c44f1895f150a8e1cbce78539f988230', '2');
INSERT INTO tbl_transaction VALUES('3', '0', '0', '1', '0', '0', '3', '0', '', '', '', '2025-08-09 08:57:00', '', '', '21000.00', '0.00', '12', '0', 'b049d3e2f027453c1a7d8400473e0ec2c44f1895f150a8e1cbce78539f988230', '2');
INSERT INTO tbl_transaction VALUES('4', '0', '0', '1', '0', '0', '4', '0', '', '', '', '2025-08-09 09:34:00', '', '', '30000.00', '30000.00', '13', '0', 'b049d3e2f027453c1a7d8400473e0ec2c44f1895f150a8e1cbce78539f988230', '2');
INSERT INTO tbl_transaction VALUES('5', '0', '0', '1', '0', '0', '5', '0', '', '', '', '2025-08-09 09:40:27', '', '', '500.00', '500.00', '9', '0', 'ea966bc09283b428aea23391fc32119a702c244f7e0e3efb4f3824f8c74d701b', '2');
INSERT INTO tbl_transaction VALUES('6', '0', '0', '1', '0', '0', '6', '0', '', '', '', '2025-08-10 08:42:02', '', '', '1000.00', '0.00', '4', '0', 'e31cde63c8b6222bf781ddb5b6064ce9f369b33fe4d93b043db0582fa3132e64', '2');
INSERT INTO tbl_transaction VALUES('7', '0', '0', '1', '0', '0', '7', '0', '', '', '', '2025-08-10 08:45:03', '', '', '600.00', '0.00', '4', '0', 'e31cde63c8b6222bf781ddb5b6064ce9f369b33fe4d93b043db0582fa3132e64', '2');
INSERT INTO tbl_transaction VALUES('8', '0', '0', '1', '0', '0', '8', '0', '', '', '', '2025-08-10 08:48:04', '', '', '400.00', '0.00', '4', '0', 'e31cde63c8b6222bf781ddb5b6064ce9f369b33fe4d93b043db0582fa3132e64', '2');
INSERT INTO tbl_transaction VALUES('9', '0', '0', '1', '0', '0', '9', '0', '', '', '', '2025-08-10 08:48:41', '', '', '300.00', '0.00', '4', '0', 'e31cde63c8b6222bf781ddb5b6064ce9f369b33fe4d93b043db0582fa3132e64', '2');
INSERT INTO tbl_transaction VALUES('10', '0', '0', '1', '0', '0', '10', '0', '', '', '', '2025-08-10 08:50:54', '', '', '600.00', '0.00', '4', '0', 'e31cde63c8b6222bf781ddb5b6064ce9f369b33fe4d93b043db0582fa3132e64', '2');
INSERT INTO tbl_transaction VALUES('11', '0', '0', '1', '0', '0', '11', '0', '', '', '', '2025-08-10 08:55:07', '', '', '200.00', '0.00', '4', '0', 'e31cde63c8b6222bf781ddb5b6064ce9f369b33fe4d93b043db0582fa3132e64', '2');
INSERT INTO tbl_transaction VALUES('12', '0', '0', '1', '0', '0', '12', '0', '', '', '', '2025-08-10 08:55:25', '', '', '200.00', '200.00', '4', '0', 'e31cde63c8b6222bf781ddb5b6064ce9f369b33fe4d93b043db0582fa3132e64', '2');
INSERT INTO tbl_transaction VALUES('13', '0', '0', '1', '0', '0', '13', '0', '', '', '', '2025-08-10 08:55:43', '', '', '400.00', '0.00', '4', '0', 'e31cde63c8b6222bf781ddb5b6064ce9f369b33fe4d93b043db0582fa3132e64', '2');
INSERT INTO tbl_transaction VALUES('14', '0', '0', '1', '0', '0', '14', '0', '', '', '', '2025-08-10 09:10:22', '', '', '500.00', '500.00', '4', '0', 'e31cde63c8b6222bf781ddb5b6064ce9f369b33fe4d93b043db0582fa3132e64', '2');
INSERT INTO tbl_transaction VALUES('15', '0', '0', '1', '0', '0', '15', '0', '', '', '', '2025-08-10 09:18:39', '', '', '500.00', '0.00', '4', '0', 'e31cde63c8b6222bf781ddb5b6064ce9f369b33fe4d93b043db0582fa3132e64', '2');
INSERT INTO tbl_transaction VALUES('16', '0', '0', '1', '0', '0', '16', '0', '', '', '', '2025-08-10 09:23:38', '', '', '300.00', '0.00', '4', '0', 'e31cde63c8b6222bf781ddb5b6064ce9f369b33fe4d93b043db0582fa3132e64', '2');
INSERT INTO tbl_transaction VALUES('17', '0', '0', '1', '0', '0', '17', '0', '', '', '', '2025-08-10 09:24:59', '', '', '400.00', '400.00', '4', '0', 'e31cde63c8b6222bf781ddb5b6064ce9f369b33fe4d93b043db0582fa3132e64', '2');
INSERT INTO tbl_transaction VALUES('18', '0', '0', '1', '0', '0', '18', '0', '', '', '', '2025-08-10 09:26:43', '', '', '200.00', '0.00', '4', '0', 'e31cde63c8b6222bf781ddb5b6064ce9f369b33fe4d93b043db0582fa3132e64', '2');
INSERT INTO tbl_transaction VALUES('19', '0', '0', '1', '0', '0', '19', '0', '', '', '', '2025-08-10 09:36:05', '', '', '400.00', '0.00', '4', '0', 'e31cde63c8b6222bf781ddb5b6064ce9f369b33fe4d93b043db0582fa3132e64', '2');
INSERT INTO tbl_transaction VALUES('20', '0', '0', '1', '0', '0', '20', '0', '', '', '', '2025-08-10 09:39:59', '', '', '400.00', '0.00', '4', '0', 'e31cde63c8b6222bf781ddb5b6064ce9f369b33fe4d93b043db0582fa3132e64', '2');
INSERT INTO tbl_transaction VALUES('21', '0', '0', '1', '0', '0', '21', '0', '', '', '', '2025-08-10 09:42:48', '', '', '700.00', '0.00', '4', '0', 'e31cde63c8b6222bf781ddb5b6064ce9f369b33fe4d93b043db0582fa3132e64', '2');
INSERT INTO tbl_transaction VALUES('22', '0', '0', '1', '0', '0', '22', '0', '', '', '', '2025-08-10 10:05:22', '', '', '700.00', '0.00', '4', '0', 'e31cde63c8b6222bf781ddb5b6064ce9f369b33fe4d93b043db0582fa3132e64', '2');
INSERT INTO tbl_transaction VALUES('23', '0', '0', '1', '0', '0', '23', '0', '', '', '', '2025-08-10 20:24:46', '', '', '500.00', '0.00', '4', '0', 'e31cde63c8b6222bf781ddb5b6064ce9f369b33fe4d93b043db0582fa3132e64', '2');
INSERT INTO tbl_transaction VALUES('24', '0', '0', '1', '0', '0', '24', '0', '', '', '', '2025-08-10 20:25:02', '', '', '300.00', '0.00', '4', '0', 'e31cde63c8b6222bf781ddb5b6064ce9f369b33fe4d93b043db0582fa3132e64', '2');
INSERT INTO tbl_transaction VALUES('25', '0', '0', '1', '0', '0', '25', '0', '', '', '', '2025-08-12 13:54:02', '', '', '1200.00', '0.00', '4', '0', 'e31cde63c8b6222bf781ddb5b6064ce9f369b33fe4d93b043db0582fa3132e64', '2');


CREATE TABLE `tbl_transactiondetails` (
  `id` int NOT NULL AUTO_INCREMENT,
  `hdrid` int NOT NULL DEFAULT '0',
  `item` int NOT NULL DEFAULT '0',
  `qty` int NOT NULL DEFAULT '0',
  `Totqty` int NOT NULL DEFAULT '0',
  `rate` decimal(10,2) NOT NULL DEFAULT '0.00',
  `amount` decimal(10,2) NOT NULL DEFAULT '0.00',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=31 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO tbl_transactiondetails VALUES('1', '1', '1', '1', '1', '100.00', '100.00');
INSERT INTO tbl_transactiondetails VALUES('2', '2', '1', '50', '50', '100.00', '5000.00');
INSERT INTO tbl_transactiondetails VALUES('3', '3', '1', '200', '200', '100.00', '20000.00');
INSERT INTO tbl_transactiondetails VALUES('4', '3', '2', '1', '10', '1000.00', '1000.00');
INSERT INTO tbl_transactiondetails VALUES('5', '4', '1', '300', '300', '100.00', '30000.00');
INSERT INTO tbl_transactiondetails VALUES('6', '5', '1', '5', '5', '100.00', '500.00');
INSERT INTO tbl_transactiondetails VALUES('7', '6', '1', '10', '10', '100.00', '1000.00');
INSERT INTO tbl_transactiondetails VALUES('8', '7', '1', '6', '6', '100.00', '600.00');
INSERT INTO tbl_transactiondetails VALUES('9', '8', '1', '4', '4', '100.00', '400.00');
INSERT INTO tbl_transactiondetails VALUES('10', '9', '1', '3', '3', '100.00', '300.00');
INSERT INTO tbl_transactiondetails VALUES('11', '10', '1', '6', '6', '100.00', '600.00');
INSERT INTO tbl_transactiondetails VALUES('12', '11', '1', '2', '2', '100.00', '200.00');
INSERT INTO tbl_transactiondetails VALUES('13', '12', '1', '2', '2', '100.00', '200.00');
INSERT INTO tbl_transactiondetails VALUES('14', '13', '1', '4', '4', '100.00', '400.00');
INSERT INTO tbl_transactiondetails VALUES('15', '14', '1', '5', '5', '100.00', '500.00');
INSERT INTO tbl_transactiondetails VALUES('16', '15', '1', '5', '5', '100.00', '500.00');
INSERT INTO tbl_transactiondetails VALUES('17', '16', '1', '3', '3', '100.00', '300.00');
INSERT INTO tbl_transactiondetails VALUES('18', '17', '1', '4', '4', '100.00', '400.00');
INSERT INTO tbl_transactiondetails VALUES('19', '18', '1', '2', '2', '100.00', '200.00');
INSERT INTO tbl_transactiondetails VALUES('20', '19', '1', '4', '4', '100.00', '400.00');
INSERT INTO tbl_transactiondetails VALUES('21', '20', '1', '4', '4', '100.00', '400.00');
INSERT INTO tbl_transactiondetails VALUES('22', '21', '1', '7', '7', '100.00', '700.00');
INSERT INTO tbl_transactiondetails VALUES('23', '22', '1', '7', '7', '100.00', '700.00');
INSERT INTO tbl_transactiondetails VALUES('24', '23', '1', '5', '5', '100.00', '500.00');
INSERT INTO tbl_transactiondetails VALUES('25', '24', '1', '3', '3', '100.00', '300.00');
INSERT INTO tbl_transactiondetails VALUES('26', '25', '1', '12', '12', '100.00', '1200.00');


CREATE TABLE `tbl_user` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `username` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `password` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `user_type` int NOT NULL DEFAULT '0',
  `ward_id` int NOT NULL DEFAULT '0',
  `mobile` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL DEFAULT '',
  `status` int NOT NULL DEFAULT '0',
  `clubid` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO tbl_user VALUES('1', 'Admin', 'admin', '4Fwpec45KtQ=', '1', '1', '8138010133', '0', '0');
INSERT INTO tbl_user VALUES('2', 'online', 'online', '4Fwpec45KtQ=', '1', '1', '8138010133', '0', '0');
INSERT INTO tbl_user VALUES('3', 'thoufeeq', '100003', 'pA12PZpsfZNqzA==', '2', '1399', '9567320776', '0', '0');
INSERT INTO tbl_user VALUES('4', 'faizal', '100004', 'tgRwMp1lNdY=', '2', '1403', '9809721612', '0', '0');
INSERT INTO tbl_user VALUES('5', 'jamsheeram ', '100005', 'ugR0O5RsfZBnnvmxCbQ=', '2', '1399', '9048911686', '0', '0');
INSERT INTO tbl_user VALUES('6', 'ahammadanafi', '100006', 'sQ14JZFofIMpnvL4Cbc=', '2', '1399', '9847652712', '0', '0');
INSERT INTO tbl_user VALUES('7', 'ayyoobac', '100007', 'sRxgJ5NreYFqyA==', '2', '1399', '9562707072', '0', '0');
INSERT INTO tbl_user VALUES('8', 'aflahpm', '100008', 'sQN1KZR5dc9/', '2', '1399', '8943141482', '0', '0');
INSERT INTO tbl_user VALUES('9', 'sabithpt', '100009', 'owR7IYhhaJZqxg==', '2', '2315', '7907940816', '0', '3');
INSERT INTO tbl_user VALUES('10', 'farookcollegecaicut', '1000010', 'tgRrJ5Nie40rk/H2QeIVBrZ64jMmCg==', '2', '2315', '8089139648', '0', '4');
INSERT INTO tbl_user VALUES('11', 'FASALSHADE', '1000011', 'liRKCbBaUKMDurmgFQ==', '2', '2315', '7902498861', '0', '5');
INSERT INTO tbl_user VALUES('12', 'mohdkutty', '1000012', 'vQpxLJd8bJY+0qWj', '2', '2315', '9895212029', '0', '6');
INSERT INTO tbl_user VALUES('13', 'pptmcollegecherur', '1000013', 'oBVtJZ9mdI4imPHyTOQGGqcipy0=', '2', '2315', '9947553324', '0', '8');
INSERT INTO tbl_user VALUES('14', 'kamarudheen', '1000014', 'uwR0KY58fIoimvq8FbU=', '2', '2315', '9447697417', '0', '9');


CREATE TABLE `tbl_ward` (
  `id` int NOT NULL AUTO_INCREMENT,
  `panchayat_id` int NOT NULL DEFAULT '0',
  `ward_name` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL,
  `status` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2316 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO tbl_ward VALUES('1392', '68', '1 - VATTAPARAMBA', '0');
INSERT INTO tbl_ward VALUES('1393', '68', '2 - CHATHRATHODI', '0');
INSERT INTO tbl_ward VALUES('1394', '68', '3 - KAKKATHADAM', '0');
INSERT INTO tbl_ward VALUES('1395', '68', '4 - KADAPPADI', '0');
INSERT INTO tbl_ward VALUES('1396', '68', '5 - KARUVANKALLU', '0');
INSERT INTO tbl_ward VALUES('1397', '68', '6 - NADUKKARA', '0');
INSERT INTO tbl_ward VALUES('1398', '68', '7 - ILLATHUMADU', '0');
INSERT INTO tbl_ward VALUES('1399', '68', '8 - SIDHEEQABAD', '0');
INSERT INTO tbl_ward VALUES('1400', '68', '9 - PENGATTUKUNDU', '0');
INSERT INTO tbl_ward VALUES('1401', '68', '10 - POTTAMMAL MADU', '0');
INSERT INTO tbl_ward VALUES('1402', '68', '11 - KOLLAMCHINA', '0');
INSERT INTO tbl_ward VALUES('1403', '68', '12 - NEDUMPALLIYALIL', '0');
INSERT INTO tbl_ward VALUES('1404', '68', '13 - PARAMBIL PEEDIKA', '0');
INSERT INTO tbl_ward VALUES('1405', '68', '14 - PARACHINAPURAYA', '0');
INSERT INTO tbl_ward VALUES('1406', '68', '15 - CHENAKKAL', '0');
INSERT INTO tbl_ward VALUES('1408', '68', '17 - KOOMANNA ', '0');
INSERT INTO tbl_ward VALUES('1409', '68', '18 - SUPER BAZAR', '0');
INSERT INTO tbl_ward VALUES('1410', '68', '19 - VALIYAPARAMB', '0');
INSERT INTO tbl_ward VALUES('2310', '68', '21 - VADAKKEELMADU', '0');
INSERT INTO tbl_ward VALUES('2309', '68', '20 - VARAPPARA', '0');
INSERT INTO tbl_ward VALUES('2308', '68', '16 - PUVVATHUMADU', '0');
INSERT INTO tbl_ward VALUES('2259', '68', 'PALAPETTIPARA-IRUMBANKUDUKK AREA', '0');
INSERT INTO tbl_ward VALUES('2260', '68', 'SUPER BAZAR AREA', '0');
INSERT INTO tbl_ward VALUES('2261', '68', 'VALIYA PARAMB AREA', '0');
INSERT INTO tbl_ward VALUES('2262', '68', 'KOOMANNA CHINAKKAL AREA', '0');
INSERT INTO tbl_ward VALUES('2263', '68', 'KARUVANKALLU AREA', '0');
INSERT INTO tbl_ward VALUES('2283', '68', 'NADUKKARA AREA', '0');
INSERT INTO tbl_ward VALUES('2285', '68', 'msf kadappadi unit', '0');
INSERT INTO tbl_ward VALUES('2286', '68', 'LEAGUE HOUSE CHATHRATHODI', '0');
INSERT INTO tbl_ward VALUES('2303', '68', 'MYL KOOMANNA VALIYAPARAMB', '0');
INSERT INTO tbl_ward VALUES('2315', '123', 'NA', '0');


