<?php

// get_assemblies.php
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST, GET, OPTIONS');
header('Access-Control-Max-Age: 1000');
header('Access-Control-Allow-Headers: Content-Type');
require_once('../lib/dbclass.php');
// Include your database connection or include a database handler here.


$conn = mysqli_connect('localhost', DB_USERNAME, DB_PASSWORD, DB_NAME);

if (isset($_GET['district_id'])) {
    $district_id = $_GET['district_id'];

    // Query to get assemblies based on the selected district
    $query = 'SELECT id, panchayat_name name FROM tbl_panchayat WHERE assembly_id = ? AND status = 0';
    $stmt  = $conn->prepare($query);
    $stmt->bind_param('i', $district_id);

    $stmt->execute();
    $result = $stmt->get_result();



    // Initialize an array to hold the options
    $assemblies = [];

    while ($row = $result->fetch_assoc()) {
        $assemblies[] = $row;
    }

    // Return the data as a JSON response
    echo json_encode($assemblies);

    return;
}
