<?php

function containsNonEnglishCharacters($string)
{
    // Regular expression for matching non-English characters
    if (preg_match('/[^\x20-\x7E]/', $string)) {
        return true; // Contains non-English characters
    }

    return false; // Contains only English characters
}

// Example usage:
$string1 = 'Hello, World///***8898577!';
$string2 = 'മലയാളത്തിൽ ടൈപ്പ്';

echo containsNonEnglishCharacters($string1) ? "Non-English characters found\n" : "Only English characters\n";
echo containsNonEnglishCharacters($string2) ? "Non-English characters found\n" : "Only English characters\n";
